//
//  CRParameterDescriptor.h
//  CRKit
//
//  Created by Yaroslav Glushchenko on 3/4/10.
//  Copyright 2010 Corner-A. All rights reserved.
//


//////////////////////////////////////////////////////////////////////
// Object parameter
//////////////////////////////////////////////////////////////////////
typedef enum {
	CRUsageNone			= 0x00,
	CRUsageCoding		= 0x01,
	CRUsageUndo			= 0x02,
	CRUsageCopying		= 0x04,
	
	CRUsageData			= CRUsageCoding | CRUsageCopying,
	CRUsageAll			= CRUsageCoding | CRUsageUndo | CRUsageCopying,
} CRParameterUsage;

@interface CRParameterDescriptor : NSObject
{
	NSString*	keyPath;
	NSUInteger	usage;
	NSString*	codingTransformer;
}

@property (nonatomic, readonly) NSString*	keyPath;
@property (nonatomic, readonly) NSUInteger	usage;
@property (nonatomic, readonly) NSString*	codingTransformer;
@property (nonatomic, readonly) BOOL		useInUndo;
@property (nonatomic, readonly) BOOL		useInCoding;
@property (nonatomic, readonly) BOOL		useInCopying;

- (id)initWithKeyPath:(NSString*)aKeyPath usage:(NSUInteger)usage codingTransformer:(NSString *)transformerName;
+ (id)descriptorWithKeyPath:(NSString*)aKeyPath usage:(NSUInteger)usage codingTransformer:(NSString *)transformerName;
+ (id)descriptorWithKeyPath:(NSString*)aKeyPath usage:(NSUInteger)usage;

- (id)forwardTransform:(id)value;
- (id)reverseTransform:(id)value;

@end